<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Services\Registration;
use App\Imports\StudentImport;
use App\Models\User;
use Illuminate\Http\Request;

class StudentsController extends Controller
{
    /**
     * [Description for index]
     *
     * @return [type]
     *
     */
    public function index()
    {
        $students = User::Student()->get();
        return view('students.list')->with('students', $students);
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required|email|unique:users',
        ], [
            'name.required' => 'يرجى اضافة الاسم .',
            'email.required' => 'يرجى اضافة الإيميل .',
            'email.email' => 'يرجى اضافة إيميل صحيح .',
            'email.unique' => 'هذا الإيميل مستخدم من قبل  .']);
        try {

            $newStudent = new User();
            $newStudent->name = $request->name;
            $newStudent->email = $request->email;
            if (!$request->nameCertificate == null) {
                $newStudent->certificate_name = $request->nameCertificate;
            }

            if (!$request->phone == null) {
                $newStudent->phone = $request->phone;
            }

            $newStudent->role = 2;
            $newStudent->save();
            if (Registration::sendMails($newStudent)) {
                return back()->with(['success' => 'تم إضافة بيانات المتدرب بنجاح']);
            }

            return back()->with(['warning' => 'تم إضافة بيانات المتدرب ولم يرسل ايميل التفعيل']);
        } catch (\Throwable$th) {
            return back()->with(['error' => 'لم يتم إضافة بيانات المتدرب  ']);
        }
    }
    /**
     * [Description for import]
     *
     * @param Request $request
     *
     * @return [type]
     *
     */
    public function import(Request $request)
    {
        $request->validate([
            'studentFile' => 'required|mimes:xlsx',
        ], [
            'studentFile.required' => 'يرجى ارفاق الملف',
            'studentFile.mimes' => 'يرجى التاكد من صيفة الملف',
        ]);
        try {
            $file = $request->file('studentFile');
            $import = new StudentImport;
            $import->import($file);
            if ($import->failures()->isNotEmpty()) {
                return back()->with(['import_errors' => $import->failures()]);
            }
            //call method wih  send email
            return back()->with(['success' => ' تم استيراد الملف ونعمل حاليا على تخزينها في قاعدة البيانات ,سيتم ارسال اشعار اذا كان هناك خطاء']);
        } catch (\Maatwebsite\Excel\Validators\ValidationException$e) {
            $failures = $e->failures();
            return back()->with(['import_errors' => $failures]);
        }

    }

    /**
     * [Description for update]
     *
     * @param Request $request
     *
     * @return [type]
     *
     */
    public function update(Request $request)
    {
        try {
            $updateStudent = User::find($request->id);
            $updateStudent->name = $request->name;
            $updateStudent->email = $request->email;
            if (!$request->phone == null) {
                $updateStudent->phone = $request->phone;
            }

            if (!$request->nameCertificate == null) {
                $updateStudent->certificate_name = $request->nameCertificate;
            }

            $updateStudent->update();
            return back()->with(['success' => 'تم تحديث بيانات المتدرب بنجاح']);
        } catch (\Throwable$th) {
            return back()->with(['error' => 'لم يتم تحديث البيانات ']);
        }

    }
    public function delete(Request $request)
    {
        try {
            User::find($request->id)->delete();
            return back()->with(['success' => 'تمت حذف المتدرب بنجاح']);
        } catch (\Throwable$th) {
            return back()->with(['error' => 'لم يتم حذف المتدرب ']);
        }
    }
    /**
     * [This method using to active and not active ]
     *
     * @param Request $request
     *
     * @return [type]
     *
     */
    public function toggle(Request $request)
    {
        try {
            $student = User::find($request->id);
            $student->is_active *= -1;
            $student->save();
            return back()->with(['success' => 'تمت تحديث البيانات بنجاح']);
        } catch (\Throwable$th) {
            return back()->with(['error' => 'لم يتم تحديث البيانات']);
        }
    }

}
